unit DFilterService01;
(*
   ========================================================================
    " " DFiltr.
       .
   ========================================================================
     :
      1.    
      2.     
      3.     
   ========================================================================
    
   ()  ,    , , .
   ========================================================================
       
   ()   , ,  
   ========================================================================
*)
interface
uses
  // 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtDlgs, StdCtrls, ComCtrls, ExtCtrls, Buttons, ImgList, Grids,
  //        
  EngineMainData01, MainData,
  //  
  EngineImgService01,
  //    
  DFilterMainData01;

// ------------------------------------------------------------------------
//   
function VerifyFilterScale() : boolean;
// ------------------------------------------------------------------------
//   
function CalculateScale(RqEdit : TEdit) : boolean;
//    
function CalcDFScale(RqDFArray : TDFiltrArray) : integer;
// ------------------------------------------------------------------------
//    
procedure DFilterAplly (DFArr         : TDFiltrArray;   //  
                         FScale        : integer;        // 
                         ptSourceArray : ptImgTabColor;  // . 
                         ptTargetArray : ptImgTabColor;  // . 
                         ProgressBar   : TProgressBar);
// ------------------------------------------------------------------------

implementation

// ========================================================================
//   
// ========================================================================
// 30.01.2013
//    (     )
function VerifyFilterScale() : boolean;
var FRow, FCol : byte;
    Scale      : integer;
begin
   Result := False;
   Scale := 0;
   for FRow := 0 to High(DFiltrArray) do
   begin
     for FCol := 0 to High(DFiltrArray[FRow]) do
     begin
         Scale := Scale + DFiltrArray[FRow, FCol];
     end;
   end;
   if Scale > 0 then Result := True;
end;
// ------------------------------------------------------------------------
// 30.01.2013
//   
function CalculateScale(RqEdit : TEdit) : boolean;
var FRow, FCol : byte;
begin
   Result := False;
   DFiltrScale := 0;
   for FRow := 0 to High(DFiltrArray) do
   begin
     for FCol := 0 to High(DFiltrArray[FRow]) do
     begin
         DFiltrScale := DFiltrScale + DFiltrArray[FRow, FCol];
     end;
   end;
   RqEdit.Text := IntToStr(DFiltrScale);
   if DFiltrScale > 0 then Result := True;
end;

// ------------------------------------------------------------------------
// 19.02.2013
//   
function CalcDFScale(RqDFArray : TDFiltrArray) : integer;
var FRow, FCol : byte;
begin
   Result := 0;
   for FRow := Low(RqDFArray) to High(RqDFArray) do
     for FCol := Low(RqDFArray[FRow]) to High(RqDFArray[FRow]) do
     begin
         Result := Result + RqDFArray[FRow, FCol];
     end;
end;

// ========================================================================
//    
// ========================================================================

// !      DFilterMaxLen = 5;
//       DFilterMaxLen


//       
type TRowCol = record
  R : integer;
  C : integer;
end;

//     ,     
const NDFArea = DFilterFocusRC;

//      
const ArrRC : array [0..DFilterMaxLen-1, 0..DFilterMaxLen-1] of TRowCol =
(
 ((R:-3;C:-3),(R:-3;C:-2),(R:-3;C:-1),(R:-3;C:+0),(R:-3;C:+1),(R:-3;C:+2),(R:-3;C:+3)),
 ((R:-2;C:-3),(R:-2;C:-2),(R:-2;C:-1),(R:-2;C:+0),(R:-2;C:+1),(R:-2;C:+2),(R:-2;C:+3)),
 ((R:-1;C:-3),(R:-1;C:-2),(R:-1;C:-1),(R:-1;C:+0),(R:-1;C:+1),(R:-1;C:+2),(R:-1;C:+3)),
 ((R:+0;C:-3),(R:+0;C:-2),(R:+0;C:-1),(R:+0;C:+0),(R:+0;C:+1),(R:+0;C:+2),(R:+0;C:+3)),
 ((R:+1;C:-3),(R:+1;C:-2),(R:+1;C:-1),(R:+1;C:+0),(R:+1;C:+1),(R:+1;C:+2),(R:+1;C:+3)),
 ((R:+2;C:-3),(R:+2;C:-2),(R:+2;C:-1),(R:+2;C:+0),(R:+2;C:+1),(R:+2;C:+2),(R:+2;C:+3)),
 ((R:+3;C:-3),(R:+3;C:-2),(R:+3;C:-1),(R:+3;C:+0),(R:+3;C:+1),(R:+3;C:+2),(R:+3;C:+3))
);
// ------------------------------------------------------------------------
// 20.02.2013
//   ,      
//     
procedure NormLight(var R, G, B : double);
var WInd : byte;
    WMax : double;
    NSc  : double;
begin
   //      
   WMax := R - 255; WInd := 1;
   if G - 255 > WMax then begin WMax := G - 255;  WInd := 2; end;
   if B - 255 > WMax then WInd := 3;
   //  
   case WInd of
   1 : NSc := 255/R;
   2 : NSc := 255/G;
   3 : NSc := 255/B;
   else NSc := 1;
   end;
   //  
   R := NSc * R;
   G := NSc * G;
   B := NSc * B;
end;
// ------------------------------------------------------------------------
// 20.02.2013     NormLight
//   ,     
//    
procedure NormDark(var R, G, B : double);
var WInd : byte;
    WMin : double;
    NSc  : double;
begin
   //    
   WMin := R;  WInd := 1;
   if G < WMin then begin WMin := G; WInd := 2; end;
   if B < WMin then WInd := 3;
   //  
   case WInd of
   1 : NSc := 255/(255-R);
   2 : NSc := 255/(255-G);
   3 : NSc := 255/(255-B);
   else NSc := 1;
   end;
   //  
   R := 255 - NSc * (255-R);
   G := 255 - NSc * (255-G);
   B := 255 - NSc * (255-B);
end;
// ------------------------------------------------------------------------
// 20.02.2013
procedure CheckAndNormPixel (CScale : double;
                             WRow, WCol  : integer;
                             ptSourceArray : ptImgTabColor;
                             ptTargetArray : ptImgTabColor);
var R, G, B : double;
begin
   //        
   B := CScale * ptSourceArray^[WRow, WCol].B;
   G := CScale * ptSourceArray^[WRow, WCol].G;
   R := CScale * ptSourceArray^[WRow, WCol].R;
   //     
   if (B < 0) or (G < 0) or (R < 0) then NormDark(R, G, B);
   //     
   if (B > 255) or (G > 255) or (R > 255) then NormLight(R, G, B);
   //      
   ptTargetArray^[WRow, WCol].B := Trunc(B);
   ptTargetArray^[WRow, WCol].G := Trunc(G);
   ptTargetArray^[WRow, WCol].R := Trunc(R);
end;

// ------------------------------------------------------------------------
// 20.02.2013
//   ,    
procedure NDFAreaAplly (DFArr         : TDFiltrArray;
                        FScale        : integer;
                        ptSourceArray : ptImgTabColor;
                        ptTargetArray : ptImgTabColor);
var
    IScale      : integer;      //   
    CScale      : double;       //  
    WRow, WCol  : integer;      //     
begin
  //    
   IScale := CalcDFScale(DFArr);
   if IScale < 1 then Exit;
   //   
   CScale := IScale / FScale;
   //   
   for WRow := Low(ptSourceArray^) to Low(ptSourceArray^) + NDFArea do
     for WCol := Low(ptSourceArray^[WRow]) to High(ptSourceArray^[WRow])
     do begin
      CheckAndNormPixel (CScale, WRow, WCol, ptSourceArray, ptTargetArray);
     end;
   //   
   for WRow := High(ptSourceArray^)- NDFArea to High(ptSourceArray^) do
     for WCol := Low(ptSourceArray^[WRow]) to High(ptSourceArray^[WRow])
     do begin
      CheckAndNormPixel (CScale, WRow, WCol, ptSourceArray, ptTargetArray);
     end;
   //   
   for WRow := Low(ptSourceArray^) to High(ptSourceArray^) do
     for WCol := Low(ptSourceArray^[WRow])
     to Low(ptSourceArray^[WRow]) + NDFArea
     do begin
      CheckAndNormPixel (CScale, WRow, WCol, ptSourceArray, ptTargetArray);
     end;
  //   
  for WRow := Low(ptSourceArray^) to High(ptSourceArray^) do
     for WCol := High(ptSourceArray^[WRow])- NDFArea
     to High(ptSourceArray^[WRow])
     do begin
      CheckAndNormPixel (CScale, WRow, WCol, ptSourceArray, ptTargetArray);
     end;
end;

// ------------------------------------------------------------------------
// 20.02.2013
//     DFilterMaxLen = 5
procedure DFilterAplly (DFArr         : TDFiltrArray;   //  
                        FScale        : integer;        // 
                        ptSourceArray : ptImgTabColor;  // . 
                        ptTargetArray : ptImgTabColor;  // . 
                        ProgressBar   : TProgressBar);
var
    WRow, WCol  : integer;      //     
    Row,  Col   : integer;      //      
    DFW         : integer;      //    ( )
    RIn,  CIn   : integer;      //     
    BSum, GSum, RSum : double;  //    
    //
begin
 // ------------
 //    
 SetLength(ptTargetArray^, Length(ptSourceArray^));
 //       
 for WRow := Low(ptSourceArray^) to High(ptSourceArray^)
 do SetLength(ptTargetArray^[WRow], Length(ptSourceArray^[WRow]));
 // ------------
 //  
 ProgressBar.Min := 0;
 ProgressBar.Max := Length(ptSourceArray^);
 ProgressBar.Position := ProgressBar.Min;
 // ------------
 //   ,    
 NDFAreaAplly (DFArr, FScale, ptSourceArray, ptTargetArray);
 // ------------
 //      
 for WRow := Low(ptSourceArray^) + NDFArea
 to High(ptSourceArray^) - NDFArea do
 begin
    // -------------------------------------------------
    for WCol := Low(ptSourceArray^[WRow]) + NDFArea
    to  High(ptSourceArray^[WRow]) - NDFArea do
    begin
       // -----------    
       BSum   := 0;   //     Blue
       GSum   := 0;   //     Green
       RSum   := 0;   //     Red
       //
       //       
       for Row := Low(ArrRC) to High(ArrRC) do
         for Col := Low(ArrRC[Row]) to High(ArrRC[Row])
         do begin
           //      
           DFW := DFArr[Row, Col];
           if DFW <> 0
           then begin
             //      
             RIn := WRow + ArrRC[Row, Col].R;   // Row 
             CIn := WCol + ArrRC[Row, Col].C;   // Col 
             //   
             BSum := BSum + ptSourceArray^[RIn, CIn].B * DFW;
             GSum := GSum + ptSourceArray^[RIn, CIn].G * DFW;
             RSum := RSum + ptSourceArray^[RIn, CIn].R * DFW;
           end;
         end;
       //      
       BSum := BSum / FScale;
       GSum := GSum / FScale;
       RSum := RSum / FScale;
       //     
       if (BSum < 0) or (GSum < 0) or (RSum < 0)
       then NormDark(RSum, GSum, BSum);
       //     
       if (BSum > 255) or (GSum > 255) or (RSum > 255)
       then NormLight(RSum, GSum, BSum);
       //      
       ptTargetArray^[WRow, WCol].B := Trunc(BSum);
       ptTargetArray^[WRow, WCol].G := Trunc(GSum);
       ptTargetArray^[WRow, WCol].R := Trunc(RSum);
       // -----------    
    end;
    //  
    ProgressBar.Position := ProgressBar.Position + 1;
 end;
end;
// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
